import React from "react";
import "./AboutSec.css";
import Image from "next/image";
import aboutSecImage from "../../../public/images/book-cover1.png";
import Link from "next/link";

const AboutSec = ({ gotoNextSec }) => {
  return (
    <section className="about-sec" ref={gotoNextSec}>
      <div className="container">
        <div className="row">
          <div className="col-lg-12" data-aos="fade-up">
            <div className="about-content">
              <div className="tag-box">About the book</div>

              <h2>The Heartbreaking Search That Became a Fight for Freedom</h2>
              <p className="para">
                A true story proving love never quits, even in darkness.
              </p>
            </div>
          </div>
        </div>
        <div className="row align-items-center">
          <div className="col-lg-3">
            <div className="about-sec-para" data-aos="fade-right">
              <p className="para">
                When Angela’s uncle vanished after surviving a tragic fire, her
                world stopped. What began as a desperate search for family
                turned into a battle against lies, greed, and corruption. With
                every door closed and every truth buried, she refused to stay
                silent. Her love for her uncle became the force that kept her
                fighting when the system failed them both.
              </p>
            </div>
          </div>
          <div className="col-lg-6">
            <div className="about-sec-image">
              <Image
                src={aboutSecImage}
                width={710}
                height={630}
                alt="about-sec-image"
              />
            </div>

            <div className="about-btn">
              <Link href={"#"} className="btn-golden">
                Learn More
              </Link>
            </div>
          </div>
          <div className="col-lg-3">
            <div
              className="about-sec-para about-sec-para-right"
              data-aos="fade-up"
            >
              <p className="para">
                This book shares the real story of faith, pain, and courage that
                changed everything. It’s about standing tall when life tries to
                break you, and believing that truth always finds a way. Hide and
                Seek isn’t just a story, it's proof that bond, faith, and
                determination can shine light even in the darkest places.
              </p>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default AboutSec;
