import React from "react";
import "./Blogs.css";
import Link from "next/link";
import Image from "next/image";

// import blogDetailBox from "../../../public/images/blog-detail-box.png";

const Blogs = () => {
  return (
    <>
      <section className="blogs-sec">
        <div className="container">
          <div className="row">
            <div className="col-lg-12">
              <div className="blogs-content" data-aos="fade-up">
                <div className="tag-box">Blogs</div>

                <h2>From the Search to the Story</h2>
                <p className="para">
                  Step into Angela’s world as she opens up about her journey,
                  her faith, and the truths she uncovered along the way.
                </p>
              </div>
            </div>
          </div>

          <div className="row">
            <div className="col-lg-8">
              <div className="blog-card">
                <div className="blog-card-inner">
                  <div
                    className="blog-card-front big-blogs"
                    data-aos="fade-right"
                  >
                    <div className="big-blogs-content big-blogs-content1">
                      <span>A Niece Desperate Search to find her uncle</span>
                      <h2
                        className="white-heading"
                        data-bs-toggle="modal"
                        data-bs-target="#exampleModal"
                        type="button"
                      >
                        Faith in the Fire: The Story Behind Hide and Seek
                      </h2>
                    </div>
                  </div>

                  <div className="blog-card-back">
                    <div className="back-content">
                      {/* <h3>Behind the Scenes</h3> */}
                      <p>
                        After enduring a traumatic experience of being trapped
                        in a burning building for five days, my uncle’s case
                        took a disturbing turn. He was allegedly abducted by his
                        ex partner and an attorney acting on her behalf, then
                        concealed within a hospital facility where he was
                        registered under a Alias name. For four years, he
                        remained hidden from his loved ones, living among
                        patients and paying rent to the institution under an
                        alias. This shocking situation raises serious legal and
                        ethical concerns, an apparent violation of human rights
                        and a troubling example of systemic failure and
                        negligence.
                      </p>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div className="col-lg-4">
              <div className="blog-card2">
                <div className="blog-card2-inner">
                  <div
                    className="blog-card2-front2 small-blogs"
                    data-aos="fade-up"
                  >
                    <div className="big-blogs-content">
                      <span>A Niece Desperate Search to find her uncle</span>
                      <h2 className="white-heading">
                        He Became Everything My Heart Was Missing
                      </h2>
                    </div>
                  </div>

                  <div className="blog-card2-back">
                    <div className="back-content">
                      <p>
                        He isn't just my uncle, he is my protector, my
                        strength, and the steady presence I could always count
                        on. After my father passed, he stepped forward
                        naturally, filling that space with love, wisdom, and
                        faith. This moment captures exactly who he is to me, not
                        just family, but the father my heart chose.
                      </p>
                    </div>
                  </div>
                </div>
              </div>

              <div className="blog-card3 mt-3">
                <div className="blog-card3-inner">
                  <div
                    className="blog-card3-front2 small-blogs"
                    data-aos="fade-up"
                  >
                    <div className="big-blogs-content">
                      <span>A Niece Desperate Search to find her uncle</span>
                      <h2 className="white-heading">
                        The Door That Tried to Erase Him!
                      </h2>
                    </div>
                  </div>

                  <div className="blog-card3-back">
                    <div className="back-content">
                      <p>
                        They called him “Confidential No. 5.” No name. No
                        identity. Just a number on a door meant to erase who he
                        was. Hidden in plain sight, he was silenced by the
                        system but not forgotten. I knew he was there. My heart
                        never stopped fighting to bring him back into our life.
                      </p>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <div className="col-lg-6">
              <div className="flipper">
                <div
                  className="small-blogs small-blogs3 mt-3"
                  data-aos="fade-up"
                >
                  <div className="big-blogs-content">
                    <span>A Niece Desperate Search to find her uncle</span>
                    <h2 className="white-heading">
                      Family that prays together, stays together
                    </h2>
                  </div>
                </div>
                <div className="back small-blogs small-blogs3 mt-3">
                  <div className="big-blogs-content">
                    <p>
                      Our talks were daily, our bond unbreakable. Whether it was
                      a quick call, a ride, or a Sunday at church, being with
                      him feels like home. His faith strengthened mine, his love
                      guided me. Those shared prayers became our promise that no
                      matter what, Family that prays together truly stays
                      together.
                    </p>
                  </div>
                </div>
              </div>
            </div>

            <div className="col-lg-6">
              <div className="flipper">
                <div
                  className="small-blogs small-blogs4 mt-3"
                  data-aos="fade-up"
                >
                  <div className="big-blogs-content">
                    <span>A Niece Desperate Search to find her uncle</span>
                    <h2 className="white-heading">
                      A Promise of Love That Endures
                    </h2>
                  </div>
                </div>
                <div className="back small-blogs small-blogs4 mt-3">
                  <div className="big-blogs-content">
                    <p>
                      Every moment with you was a gift I’ll never forget. Your
                      love still guides me, your laughter still warms me. I
                      promised to always fight for you and I do. Though life has
                      changed, my heart still stands beside you, forever
                      anchored in love and faith.
                    </p>
                  </div>
                </div>
              </div>
            </div>
          </div>

          <div className="row">
            <div className="col-lg-12">
              <div className="blogs-btn">
                <Link href={"/"} className="btn-golden">
                  View More
                </Link>
              </div>
            </div>
          </div>
        </div>
      </section>
    </>
  );
};

export default Blogs;
