import React from "react";
import "./BuyTheBook.css";
import Image from "next/image";

import bookImage from "../../../public/images/book.png";
import Link from "next/link";

const BuyTheBook = () => {
  return (
    <section className="by-the-book">
      <div className="container">
        <div className="row align-items-center">
          <div className="col-lg-6">
            <div className="by-the-book-content" data-aos="fade-right">
              <h2 className="black-heading">
                The Fight Isn’t Over <br /> Volume 2 is Coming !!
              </h2>
              <p className="para">
                Books By Angela Brunson’s journey began with love and loss, but it didn’t
                end there. Hide and Seek tells the true story of a niece who
                refuses to stop fighting for her missing uncle and the justice
                they both deserve. Every page reveals new twists, hidden truths,
                and a system built to silence those who speak out.
              </p>

              <p className="para">
                <b><i>But the story is far from over. Volume 2 uncovers deeper
                secrets, darker turns, and shocking truths that will leave you
                questioning everything you thought you knew. The search
                continues more intense, more emotional, and more revealing than
                ever. The fight for truth doesn’t end here… it’s only just
                beginning.</i></b>
              </p>

              <div className="by-the-book-btn d-flex">
                <Link href={"https://www.amazon.com/dp/B0FVPW7QQR?ref=cm_sw_r_ffobk_cp_ud_dp_1WD79HV0M23X9W20JTM3&ref_=cm_sw_r_ffobk_cp_ud_dp_1WD79HV0M23X9W20JTM3&social_share=cm_sw_r_ffobk_cp_ud_dp_1WD79HV0M23X9W20JTM3&bestFormat=true"} target="_blank" className="btn-black">
                  Buy the Book
                </Link>
              </div>
            </div>
          </div>
          <div className="col-lg-6">
            <div className="book-image" data-aos="fade-up">
              <Image src={bookImage} alt="book-image" />
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default BuyTheBook;
