import React, { useState } from "react";
import "./ContactSec.css";
import Link from "next/link";

import { IoMdMail } from "react-icons/io";
import { FaFacebookF, FaInstagram, FaPhoneAlt } from "react-icons/fa";
import { IoLocationSharp } from "react-icons/io5";
import { FaXTwitter } from "react-icons/fa6";
import { GoArrowUpRight } from "react-icons/go";

const ContactSec = () => {
  const [formData, setFormData] = useState({
    name: "",
    email: "",
    phone: "",
    message: "",
    terms: false,
  });

  const [loading, setLoading] = useState(false);
  const [feedback, setFeedback] = useState(null);

  const handleChange = (e) => {
    const { name, value, type, checked } = e.target;
    setFormData({
      ...formData,
      [name]: type === "checkbox" ? checked : value,
    });
  };

  const handleSubmit = async (e) => {
    e.preventDefault();

    setLoading(true);
    setFeedback(null);

    try {
      const res = await fetch("/api/contact-us", {
        method: "POST",
        headers: { "Content-Type": "application/json" },
        body: JSON.stringify(formData),
      });

      const data = await res.json();

      if (res.ok) {
        setFeedback({ success: true, message: data.message });
        setFormData({
          name: "",
          email: "",
          phone: "",
          message: "",
          terms: false,
        });
      } else {
        setFeedback({
          success: false,
          message: data.error || "Something went wrong",
        });
      }
    } catch (err) {
      setFeedback({
        success: false,
        message: "Failed to submit. Try again later.",
      });
    } finally {
      setLoading(false);
    }
  };
  return (
    <section className="contact-sec">
      <div className="container">
        <div className="row">
          <div className="col-lg-12">
            <div className="about-content">
              <div className="tag-box">Contact Us</div>

              <h2>Connect Personally With Angela</h2>
              <p className="para">
                Inspired by her journey? Reach out your words, questions, or
                stories mean more to Angela than you know.
              </p>
            </div>
          </div>
        </div>
        <div className="row">
          <div className="col-lg-12">
            <div className="contact-sec-content">
              <div className="row">
                <div className="col-lg-5">
                  <div className="contact-sec-left">
                    <h3>
                      <span>Questions ?</span> <br /> Just let us know!
                    </h3>

                    <p className="para">
                      We’d love to hear from you share your thoughts, questions,
                      or feedback with Angela’s team today.
                    </p>

                    <ul className="contact-info">
                      <li>
                        <Link href={"mailto:thebookhideandseek@gmail.com"}>
                          <IoMdMail /> thebookhideandseek@gmail.com
                        </Link>
                      </li>
                      <li>
                        <Link href={"tel:2025360938"}>
                          <FaPhoneAlt /> (202) 536-0938
                        </Link>
                      </li>
                      <li>
                        <Link href={"#"}>
                          <IoLocationSharp /> Washington, D.C
                        </Link>
                      </li>
                    </ul>
                    <ul className="contact-social">
                      <li>
                        <Link href={"/"}>
                          <FaFacebookF size={20} color="#fff" />
                        </Link>
                      </li>
                      <li>
                        <Link href={"/"}>
                          <FaInstagram size={20} color="#fff" />
                        </Link>
                      </li>
                      <li>
                        <Link href={"/"}>
                          <FaXTwitter size={20} color="#fff" />
                        </Link>
                      </li>
                    </ul>
                  </div>
                </div>
                <div className="col-lg-7">
                  <div className="contact-form-right">
                    <h2>
                      <span>Connect</span> with Us <br /> Today!
                    </h2>
                    <form onSubmit={handleSubmit}>
                      <div className="row">
                        <div className="col-lg-12">
                          <input
                            type="text"
                            name="name"
                            placeholder="Your Name"
                            value={formData.name}
                            onChange={handleChange}
                            required
                          />
                        </div>
                        <div className="col-lg-12">
                          <input
                            type="email"
                            placeholder="Your Email"
                            name="email"
                            value={formData.email}
                            onChange={handleChange}
                            required
                          />
                        </div>
                        <div className="col-lg-12">
                          <input
                            type="number"
                            placeholder="Your Phone Number"
                            name="phone"
                            value={formData.phone}
                            onChange={handleChange}
                            required
                          />
                        </div>
                        <div className="col-lg-12">
                          <textarea
                            placeholder="Your Message"
                            name="message"
                            value={formData.message}
                            onChange={handleChange}
                            required
                          ></textarea>
                        </div>
                        <div className="col-lg-12">
                          <button 
                            type="submit"
                            disabled={loading}
                            >
                            Send
                            <GoArrowUpRight
                              color="#F6D7B8"
                              className="ms-1"
                              size={24}
                            />
                          </button>
                        </div>
                      </div>
                    </form>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default ContactSec;
