import React from "react";
import "./Footer.css";
import Link from "next/link";
import Image from "next/image";
import copyrightLogo from "../../../public/images/copyright-logo.png";
import { FaFacebookSquare, FaInstagram, FaLinkedin } from "react-icons/fa";

const Footer = () => {
  return (
    <footer className="footer">
      <div className="container">
        <div className="row">
          <div className="col-lg-12">
            <div className="footer-content">
              <p className="para">
                A powerful true story of loss, faith, and the unbreakable bond
                between family and hope a journey through <br /> heartbreak,
                healing, and the light that only God can reveal.
              </p>

              <ul className="footer-links">
                <li>
                  <Link href={"/"}>Home</Link>
                </li>
                <li>
                  <Link href={"/"}>About Book</Link>
                </li>
                <li>
                  <Link href={"/"}>About Author</Link>
                </li>
                <li>
                  <Link href={"/"}>Blogs</Link>
                </li>
                <li>
                  <Link href={"/"}>Contact Us</Link>
                </li>
              </ul>

              <ul className="footer-social-links">
                <li>
                  <Link href={"/"}>
                    <FaFacebookSquare color="#F8C18B" size={35} />
                  </Link>
                </li>
                <li>
                  <Link href={"/"}>
                    <FaInstagram color="#F8C18B" size={35} />
                  </Link>
                </li>
                <li>
                  <Link href={"/"}>
                    <FaLinkedin color="#F8C18B" size={35} />
                  </Link>
                </li>
              </ul>

              <div className="copyright">
                <Image
                  src={copyrightLogo}
                  alt="copyrightLogo"
                  width={30}
                  height={30}
                />
                <p className="para">
                  All Rights Reserved 2025 - Books By Angela Brunson . Powered by{" "}
                  <Link href={"https://xyncpublisher.com/"} target="_blank">
                    Xync Publishers
                  </Link>
                </p>
              </div>
            </div>
          </div>
        </div>
      </div>
    </footer>
  );
};

export default Footer;
