"use client";
import React, { useState } from "react";
import "./Header.css";

import Image from "next/image";
import Link from "next/link";
import LOGO_IMG from "../../../public/images/logo.png";
import { RxHamburgerMenu } from "react-icons/rx";

const Header = () => {
  const [isMenuOpen, setIsMenuOpen] = useState(false);

  return (
    <header className="header">
      <div className="container">
        <div className="row">
          <div className="col-lg-12">
            <div className="header-content">
              <ul>
                <li>
                  <Link href={"/"}>Home</Link>
                </li>
                <li>
                  <Link href={"/"}>About Book</Link>
                </li>
                <li>
                  <Link href={"/"}>About Author</Link>
                </li>
              </ul>

              <div className="header-image">
                <Link href={"/"}>
                  <Image src={LOGO_IMG} width={232} height={72} alt="logo" />
                </Link>
              </div>

              <ul>
                <li>
                  <Link href={"/"}>Testimonials</Link>
                </li>
                <li>
                  <Link href={"/"}>Blogs</Link>
                </li>
                <li>
                  <Link href={"/"}>Contact Us</Link>
                </li>
              </ul>
            </div>

            <div className="mobile-header">
              <div className="mobile-header-inner">
                <div className="mobile-logo">
                  <Image src={LOGO_IMG} width={160} height={50} alt="logo" />
                </div>

                <div
                  className="mobile-hamburger"
                  onClick={() => setIsMenuOpen(true)}
                >
                  <RxHamburgerMenu size={28} color={"#000"} />
                </div>
              </div>

              <div className={`mobile-nav ${isMenuOpen ? "active" : ""}`}>
                <div className="mobile-nav-header">
                  <Image src={LOGO_IMG} width={160} height={50} alt="logo" />

                  <button
                    className="mobile-close-btn"
                    onClick={() => setIsMenuOpen(false)}
                  >
                    ✕
                  </button>
                </div>

                <ul>
                  <li>
                    <Link href={"/"} onClick={() => setIsMenuOpen(false)}>
                      Home
                    </Link>
                  </li>
                  <li>
                    <Link
                      href={"/about-book"}
                      onClick={() => setIsMenuOpen(false)}
                    >
                      About Book
                    </Link>
                  </li>
                  <li>
                    <Link
                      href={"/about-author"}
                      onClick={() => setIsMenuOpen(false)}
                    >
                      About Author
                    </Link>
                  </li>
                  <li>
                    <Link
                      href={"/testimonials"}
                      onClick={() => setIsMenuOpen(false)}
                    >
                      Testimonials
                    </Link>
                  </li>
                  <li>
                    <Link href={"/blogs"} onClick={() => setIsMenuOpen(false)}>
                      Blogs
                    </Link>
                  </li>
                  <li>
                    <Link
                      href={"/contact"}
                      onClick={() => setIsMenuOpen(false)}
                    >
                      Contact Us
                    </Link>
                  </li>
                </ul>
              </div>
            </div>
          </div>
        </div>
      </div>
    </header>
  );
};

export default Header;
