import React from "react";
import "./AboutAuthorSec.css";

import Image from "next/image";
import aboutAuthorImage from "../../../public/images/about-author.png";
import Link from "next/link";

const AboutAuthorSec = () => {
  return (
    <section className="about-author-sec">
      <div className="container">
        <div className="row">
          <div className="col-lg-12">
            <div
              className="d-flex justify-content-center mb-5"
              data-aos="fade-up"
            >
              <div className="tag-box1">About the Author</div>
            </div>
          </div>
        </div>
        <div className="row align-items-center">
          <div className="col-lg-6">
            <div className="about-author-image" data-aos="fade-right">
              <Image src={aboutAuthorImage} alt="aboutAuthorImage" />
            </div>
          </div>
          <div className="col-lg-6">
            <div className="about-author-content" data-aos="fade-down">
              <h2 className="black-heading">
                Meet the Woman Who Refused to Stay Silent
              </h2>

              <p className="para">
                Books By Angela Brunson is a woman of strength, courage, and purpose.
                When her uncle suddenly vanished, she refused to give up. What
                began as a search for answers became a powerful fight for truth
                and justice.
              </p>
              <p className="para">
                With no legal background or support, Angela stood against a
                system that tried to silence her uncle. Guided by wisdom and
                fueled by love, she turned heartbreak into determination and
                pain into purpose
              </p>
              <p className="para">
                Today, Angela shares her story to bring hope to others who feel
                unseen or unheard. Through Hide and Seek, she reminds us that
                truth always finds the light and that love never stops
                fighting.
              </p>
              <div className="about-author-btn">
                <Link href={"/"} className="btn-black">
                  Learn More
                </Link>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default AboutAuthorSec;
