import React from "react";
import "./HomeBanner.css";
import Link from "next/link";

import { BsArrowDown } from "react-icons/bs";

const HomeBanner = ({ gotoNextSec }) => {
  const scrollToNextSection = () => {
    gotoNextSec.current.scrollIntoView({ behavior: "smooth" });
  };

  return (
    <section className="home-banner-sec">
      <div className="container">
        <div className="row align-items-center">
          <div className="col-lg-6">
            <div className="home-banner-content" data-aos="fade-right">
              <h3>One disappearance.</h3>
              <h1>One Woman’s Courage to Expose What Power Tried to Hide</h1>
              <p className="para">
                When family goes missing, love doesn’t quit. Angela’s search for
                her uncle uncovers truth, betrayal, and the power of faith.
              </p>
              <div className="home-banner-btn">
                <Link href={"/"} className="btn-black">
                  Read the Book
                </Link>
              </div>
            </div>
          </div>
          <div className="col-lg-6"></div>
          <div className="col-lg-12">
            <div className="home-banner-btn" data-aos="fade-up">
              <button onClick={scrollToNextSection}>
                <BsArrowDown size={24} color="#000" />
              </button>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default HomeBanner;
