"use client";
import React, { useEffect, useRef } from "react";
import WebLayout from "./WebLayout";
import HomeBanner from "./HomeComp/HomeBanner";
import AboutSec from "./AboutSec/AboutSec";
import AboutAuthorSec from "./AboutAuthorSec/AboutAuthorSec";
import Blogs from "./Blogs/Blogs";
import BuyTheBook from "./BuyTheBook/BuyTheBook";
import ContactSec from "./ContactSec/ContactSec";
import SubscribeSec from "./SubscribeSec/SubscribeSec";
import NewsArticles from "./NewsArticles/NewsArticles";
import VideoSec from "./VideoSec/VideoSec";
import AOS from "aos";
import "aos/dist/aos.css";

const HomePage = () => {
  const gotoNextSec = useRef(null);

  useEffect(() => {
    AOS.init({
      duration: 1000,
      once: true,
      easing: "ease-in-out",
    });
  }, []);

  return (
    <WebLayout>
      <HomeBanner gotoNextSec={gotoNextSec} />
      <AboutSec gotoNextSec={gotoNextSec} />
      <AboutAuthorSec />
      <Blogs />
      <VideoSec />
      <BuyTheBook />
      <NewsArticles />
      <ContactSec />
      <SubscribeSec />
    </WebLayout>
  );
};

export default HomePage;
