import React from "react";
import "./SubscribeSec.css";
import Image from "next/image";
import subscribeImage from "../../../public/images/subscribe-img.png";
import { GoArrowRight } from "react-icons/go";

const SubscribeSec = () => {
  return (
    <section className="subscribe-sec">
      <div className="container">
        <div className="row align-items-center">
          <div className="col-lg-6">
            <div className="subscribe-image">
              <Image src={subscribeImage} alt="subscribeImage" />
            </div>
          </div>
          <div className="col-lg-6">
            <div className="subscribe-form">
              <h3>Stay Connected The Story Continues</h3>
              <p className="para">
                Get exclusive updates, behind-the-scenes news, and first looks
                at Hide and Seek:Volume II
              </p>
              <form>
                <input type="text" placeholder="Give your Email" />
                <button type="submit">
                  Subscribe{" "}
                  <span>
                    <GoArrowRight color="#000000" size={20} />
                  </span>{" "}
                </button>
              </form>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default SubscribeSec;
